/***************************************************************************************************************
 * ArDAM1021 Lite edition - Control the Soekris dam1021 by an Arduino Nano with a 128x64 OLED display
 *
 * Project Page: 
 *
 * v0.92    03/07/2017 : - Diyaudio.com GB edition (different IR pin)
 * v0.91    31/12/2015 : - Code cleanup for release.
 * v0.90    26/08/2015 : - Code split from Universal USB to I2S Indicator project.
 *
  **************************************************************************************************************/


#include "U8glib.h"
#include <stdlib.h>
#include <IRremote.h>

// setup u8g object - select according to your specific OLED
U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NO_ACK);	                // 0.96" OLED Display using I2C which does not send ACK
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_NONE);                     // I2C / TWI 
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_DEV_0|U8G_I2C_OPT_FAST);   // Dev 0, Fast I2C / TWI
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_NO_ACK);                     // Display which does not send ACK
//U8GLIB_NHD31OLED_2X_GR u8g(3, 21, 22);  // SPI Com: SCK = 13, MOSI = 11, CS = 10, A0 = 9

// Remote control codes. They correspond to an old remote that I use for testing - change to match your remote's.
#define POWER_CODE 0xFF48B7          // Code for power on/off
#define VOLUP_CODE 0xFF30CF          // Code for Volume up
#define VOLDOWN_CODE 0xFF609F        // Code for Volume down
#define SOURCE1_CODE 0xFF827D        // Code for source 1
#define SOURCE2_CODE 0xFFB24D        // Code for source 2
#define SOURCE3_CODE 0xFFA25D        // Code for source 3
#define SOURCE0_CODE 0xFF00FF        // Code for source 0 (auto detection)
#define FILT1_CODE 0xFFB04F          // Code for Filter 1 (my remote: RETURN)
#define FILT2_CODE 0xFFB847          // Code for Filter 2 (my remote: L/R)
#define FILT3_CODE 0xFFA857          // Code for Filter 3 (my remote: STEP)
#define FILT4_CODE 0xFF58A7          // Code for Filter 4 (my remote: SLOW)

#define NUM_FONT u8g_font_fur35n     // Font for displaying the Volume and Sampling Rate
#define TEXT_FONT u8g_font_fub17     // Font for displaying text

byte x_dim;                           // Display resolution
byte y_dim;                           // Display resolution

byte str_height;
byte str_width;
byte source = 1;                      // Variable to hold the Input number. 1 for s/pdif, 2 for USB.
byte sourceold = 4;                   // Variable to hold the old Input number. 1 for s/pdif, 2 for USB.
byte type = 0;                        // Variable to hold the signal type. 0 for PCM, 1 for DSD.
byte typeold = 3;                     // Variable to hold the old signal type. 0 for PCM, 1 for DSD.
bool display_SR;
bool display_type;
bool display_source;
bool display_Vol;
bool display_Filt;

float SR = 44.1;                     // Variable to hold the detected sampling rate (or DSD type) as float.
float SRold = 1.1;                   // Variable to hold the old detected sampling rate (or DSD type) as float.
int SRint;                           // Variable to hold the detected sampling rate (or DSD type) as int.
int SRintold;                        // Variable to hold the old detected sampling rate (or DSD type) as int.
char stringSR[10];                   // Variable to hold the detected sampling rate (or DSD type) as string.
bool poweron = false;                // Variable to hold the poweron condition. Set to true if not using remote for on/off.

int Vol = 20;                        // Variable to hold the volume as int.
char stringVol[10];                  // Variable to hold the volume as string.
int Vol_old;                         // Variable to hold the old volume as int.
String filter1 = "Linear";           // The name of the filter F4
String filter2 = "Mixed";            // The name of the filter F5
String filter3 = "Minimum";          // The name of the filter F6
String filter4 = "Soft";             // The name of the filter F7

char filter[10];                     // Variable to hold the selected filter.
byte filt_num;                       // Variable to hold the number of the selected filter.
byte filt_num_old;                   // Variable for detecting filter change.

String serialin;                     // Variable to hold the data read from the serial port.

unsigned long previousMillis = 0;
long power_disp_interval = 3000;
long source_disp_interval = 3000;

#define POWERPIN 13                 // Power Relay pin.

byte RECV_PIN = 4;                  // IR Receiver input pin.
IRrecv irrecv(RECV_PIN);
decode_results results;
int prev_result;

// ------------------------ Display Sampling Rate ----------------------------------------------------
void disp_SR(void) {
  
  u8g.setFont(NUM_FONT);
  
  if ((SR-(int)SR) > 0 && poweron)
  {
    //Serial.println("displaying SR");
    str_height = u8g.getFontAscent()-u8g.getFontDescent();
    str_width = u8g.getStrWidth(dtostrf(SR, 0, 1, stringSR));
    
    u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
    u8g.print(SR, 1);
    SRold = SR;
  }
  else if ((SR-(int)SR) == 0 && poweron)
  {
    //Serial.println("displaying SR");    
    SRint = (int)SR;
    str_height = u8g.getFontAscent()-u8g.getFontDescent();
    str_width = u8g.getStrWidth(itoa(SRint, stringSR, 10));
    
    u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
    u8g.print(SRint, 1);
    SRold = SR;
  }
}

// ------------------------ Display Source -------------------------------------------------------------
void disp_source(void)
  {
    //Serial.println("disp_source");
    u8g.setFont(TEXT_FONT);
    
    str_height = u8g.getFontAscent()-u8g.getFontDescent();

    if (source == 3 && poweron)
    {
      str_width = u8g.getStrWidth("USB");
      u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
      u8g.print("USB");
      //Serial.println("USB");
    }

    else if (source == 1 && poweron)
    {
      str_width = u8g.getStrWidth("S/PDIF");
      u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
      u8g.print("S/PDIF");
      //Serial.println("S/PDIF");
    }
    
    else if (source == 2 && poweron)
    {
      str_width = u8g.getStrWidth("OPT");
      u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
      u8g.print("OPT");
      //Serial.println("OPT");
    }

    else if (source == 0 && poweron)
    {
      str_width = u8g.getStrWidth("Auto");
      u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
      u8g.print("Auto");
      //Serial.println("Auto");
    }
   SR = 0;
  }

// ------------------------ Display Signal Type ---------------------------------------------------------
void disp_type(void)
  {
    //Serial.println("disp_type");
    u8g.setFont(TEXT_FONT);
    
    str_height = u8g.getFontAscent()-u8g.getFontDescent();
   
    if (type == 0)
    {
      str_width = u8g.getStrWidth("PCM");
      u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
      u8g.print("PCM");
    }
    else
    {
      str_width = u8g.getStrWidth("DSD");
      u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
      u8g.print("DSD");
    }
  }

// ------------------------ Display Filter -------------------------------------------------------------
void disp_filter(void)
  {
    //Serial.println("disp_filter");
    u8g.setFont(TEXT_FONT);
   
    str_height = u8g.getFontAscent()-u8g.getFontDescent();
   
      str_width = u8g.getStrWidth(filter);
      u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
      u8g.print(filter);
  }

// ------------------------ Display Volume ------------------------------------------------------------
void disp_volume(void)
  {
  if (poweron)
    {
    //Serial.println("disp_volume");
    u8g.setFont(NUM_FONT);

    Vol=-1*Vol;
    str_height = u8g.getFontAscent()-u8g.getFontDescent();
    str_width = u8g.getStrWidth(itoa(Vol, stringVol, 10));
  
    u8g.setPrintPos((x_dim-str_width)/2, (y_dim/2+str_height/2));
    u8g.print(Vol);
    Vol=-1*Vol;
    }
  }

// ---------------------------- Read signal parameters --------------------------------------------------
void read_input() {
  type = 0;
  if(Serial.available())
    {        
      serialin = Serial.readStringUntil('\n');
         
      //Serial.print("I received: ");        // for debugging
      //Serial.print(serialin);              // for debugging
      //Serial.print("\n");                  // for debugging
        
      if(serialin == "L384\r")
        SR = 384;
        else
          if(serialin == "L352\r")
            SR = 352.8;
            else
              if(serialin == "L192\r")
                SR = 192;
                else
                  if(serialin == "L176\r")
                    SR = 176.4;
                    else
                      if(serialin == "L096\r")
                        SR = 96;
                        else
                          if(serialin == "L088\r")
                            SR = 88.2;
                            else
                              if(serialin == "L048\r")
                                SR = 48;
                                else
                                  if(serialin == "L044\r")
                                    SR = 44.1;
                                    else
                                      if(serialin == "L32\r")
                                      SR = 32;
  
       //Serial.print("Sampling rate is detected to be: ");    // for debugging
       //Serial.print(SR);                                     // for debugging
       //Serial.print("KHz\n");                                // for debugging
       
       serialin = "";
  
    if(SR != SRold) 
    {
      {
        u8g.firstPage();                          // display SR on OLED
          do {
              disp_SR();
             } while(u8g.nextPage());
        delay(3000);
        SRold=SR;
     }
   }
 }

}

void setup(void) {
  
  pinMode(POWERPIN, OUTPUT);
  digitalWrite(POWERPIN, LOW);
  
  x_dim = u8g.getWidth();
  y_dim = u8g.getHeight();
  
  Serial.begin(115200);  
    
  irrecv.enableIRIn();                       // Start the IR receiver
  //Serial.println("IR on");
}

void loop()
{
  if (irrecv.decode(&results)) {            // If IR code is received, get the IR code.
    //Serial.println(results.value);
    if (results.value == POWER_CODE) {      // What to do if the Power button is pressed
        //Serial.write("Power\n");
        if (poweron == false)                 // Check if already powered on
          {
            digitalWrite(POWERPIN, HIGH);
            poweron = true;
            unsigned long currentMillis = millis();
            if ((currentMillis - previousMillis) > source_disp_interval)
              {
                previousMillis = currentMillis;

                u8g.firstPage();                          // picture loop
                do {
                    disp_source();
                    } while(u8g.nextPage());
                display_SR = false;
                display_type = false;

                delay(2000);
              }
            else 
              {
                sourceold = source;
                display_Vol = false;
              }  
          }
          else 
          {
            digitalWrite(POWERPIN, LOW);
            poweron = false;
            u8g.firstPage();                          // picture loop
              do {
              } while(u8g.nextPage());
          }
    } 
    else if ((results.value == SOURCE1_CODE) && (poweron == true)) {      // What to do if the Source 1 button is pressed

        Serial.println("I1");
        source = 1;
        prev_result = 0;
    }
    else if ((results.value == SOURCE2_CODE) && (poweron == true)) {      // What to do if the Source 2 button is pressed
        
        Serial.println("I2");
        source = 2;
        prev_result = 0;
    }

    else if ((results.value == SOURCE3_CODE) && (poweron == true)) {      // What to do if the Source 3 button is pressed
        
        Serial.println("I0");
        source = 3;
        prev_result = 0;
    }

    else if ((results.value == SOURCE0_CODE) && (poweron == true)) {      // What to do if the Source 0 button is pressed
        
        Serial.println("I3");
        source = 0;
        prev_result = 0;        
    }

    else if (results.value == FILT1_CODE) {
      //SerialUSB.write("Filter 1\n");
      if(poweron) {
        Serial.println("F4");
        strncpy(filter, filter1.c_str(), 10);
        filt_num = 1;
        display_Filt = true;
      }
      prev_result = 0;
    } 

    else if (results.value == FILT2_CODE) {
      //SerialUSB.write("Filter 2\n");
      if(poweron) {
        Serial.println("F5");
        strncpy(filter, filter2.c_str(), 10);
        filt_num = 2;
        display_Filt = true;
      }
      prev_result = 0;
    }
    
    else if (results.value == FILT3_CODE) {
      //SerialUSB.write("Filter 3\n");
      if(poweron) {
        Serial.println("F6");        
        strncpy(filter, filter3.c_str(), 10);
        filt_num = 3;
        display_Filt = true;
      }
      prev_result = 0;
    }

    else if (results.value == FILT4_CODE) {
      //SerialUSB.write("Filter 4\n");
      if(poweron) {
        Serial.println("F7");
        strncpy(filter, filter4.c_str(), 10);
        filt_num = 4;
        display_Filt = true;
      }
      prev_result = 0;
    }

    else if ((results.value == VOLUP_CODE) && (poweron == true)) {      // What to do if the Volume Up button is pressed
        
        if (((Vol <= 99) && (Vol > 0)) && poweron)
          {
            Vol-=1;
            Serial.print("V-");       // output the new volume level to the DAC's serial port
            Serial.println(Vol);      // output the new volume level to the DAC's serial port
            disp_volume();
            prev_result = VOLUP_CODE;
          }
    }

    else if ((results.value == VOLDOWN_CODE) && (poweron == true)) {      // What to do if the Volume Down button is pressed
        
        if (((Vol < 99) && (Vol >= 0)) && poweron)
          {
            Vol+=1;
            Serial.print("V-");       // output the new volume level to the DAC's serial port
            Serial.println(Vol);      // output the new volume level to the DAC's serial port
            disp_volume();
            prev_result = VOLDOWN_CODE;
          }
    }

    else if (results.value == 0xFFFFFFFF) {
    switch(prev_result){
      case VOLUP_CODE:
        //Serial.write("Volume Up\n");
        if (((Vol <= 99) && (Vol > 0)) && poweron)
          {
            Vol-=1;
            Serial.print("V-");       // output the new volume level to the DAC's serial port
            Serial.println(Vol);      // output the new volume level to the DAC's serial port
            disp_volume();
            prev_result == 0;
          }
        break;
     
      case VOLDOWN_CODE:
        //Serial.write("Volume Down\n");
        if ((Vol < 99) && (Vol >= 0) && poweron)
          {
            Vol+=1;
            Serial.print("V-");       // output the new volume level to the DAC's serial port
            Serial.println(Vol);      // output the new volume level to the DAC's serial port
            disp_volume();
            prev_result == 0;
          }
        break;
      }
    }
    
    else {
      //Serial.print("unexpected value: ");
      //Serial.println(results.value, HEX);
      prev_result = 0;
   }
  irrecv.resume();                                 // Resume decoding (necessary!)
  }
  
  read_input();                              // Scan the USB Interface Module for changes in SR and/or format
     
  unsigned long currentMillis = millis();

  // -------------------------------- Display Source ------------------------------------------------------------
      if ((source != sourceold) && ((currentMillis - previousMillis) > source_disp_interval) && (poweron == true))
        {
          previousMillis = currentMillis;

          u8g.firstPage();                          // picture loop
            do {
              disp_source();
            } while(u8g.nextPage());
          display_SR = false;
          display_type = false;
          display_Vol = false;
          delay(2000);
        }
      else 
      {
        sourceold = source;
       
        if (((source == 0) || (source == 1) || (source == 2) || (source == 3)) && (poweron == true))
        {
          display_Vol = true;
        }
     }

  // -------------------------------- Display Signal Type ------------------------------------------------------------
      if ((type != typeold) && ((currentMillis - previousMillis) > source_disp_interval) && (poweron == true))
        {
            previousMillis = currentMillis;
          
            //Serial.println("displaying type");
            u8g.firstPage();                          // picture loop
            do {
                 disp_type();
               } while(u8g.nextPage());
             
            display_SR = false;
            display_Vol = false;
            delay(2000);
        }
      else 
      {
          typeold = type;
          display_Vol = true;
     }

  // -------------------------------- Display Filter ------------------------------------------------------------
      if ((filt_num != filt_num_old) && ((currentMillis - previousMillis) > source_disp_interval) && (poweron == true))
        {
            previousMillis = currentMillis;
          
            //Serial.println("displaying type");
            u8g.firstPage();                          // picture loop
            do {
                 disp_filter();
               } while(u8g.nextPage());
             
            display_SR = false;
            display_Vol = false;
            display_Filt = false;
            delay(2000);
        }
      else 
      {
          filt_num_old = filt_num;
          display_Vol = true;
     }

// -------------------------------- Display Volume ------------------------------------------------------------    
      if ((display_Vol == true) && (poweron == true))
        {
          u8g.firstPage();                          // picture loop
            do {
              disp_volume();
            } while(u8g.nextPage());
        }

// -------------------------------- Display Sampling Rate ------------------------------------------------------
  if ((display_SR == true) && ((currentMillis - previousMillis) > source_disp_interval) && (poweron == true))
    {
      previousMillis = currentMillis;
      
      u8g.firstPage();                          // picture loop
      do {
        disp_SR();
      } while(u8g.nextPage());
      display_SR = false;
      display_type = false;
      delay(2000);
    }
}

