/***************************************************************************************************************
 * ArDAM1021 Lite IR Scanner - Show detected IR code on the screen and through the serial port.
 *
 * Project Page: http://www.dimdim.gr/arduino/ardam1021-lite-project/
 *
 * v0.2    01/07/2017 : - First release.
 *
  **************************************************************************************************************/

#include "U8glib.h"
#include <stdlib.h>
#include <IRremote.h>

// setup u8g object - select according to your specific OLED
U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NO_ACK);	                // 0.96" OLED Display using I2C which does not send ACK
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_NONE);                     // I2C / TWI 
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_DEV_0|U8G_I2C_OPT_FAST);   // Dev 0, Fast I2C / TWI
//U8GLIB_SH1106_128X64 u8g(U8G_I2C_OPT_NO_ACK);                     // Display which does not send ACK
//U8GLIB_NHD31OLED_2X_GR u8g(3, 21, 22);  // SPI Com: SCK = 13, MOSI = 11, CS = 10, A0 = 9

#define TEXT_FONT u8g_font_unifont                // Font for displaying text

int RECV_PIN = 4;                                 // IR Receiver input pin.
IRrecv irrecv(RECV_PIN);
decode_results results;

void setup(void) 
  {
    u8g.setFont(TEXT_FONT);
    Serial.begin(115200);  
    u8g.firstPage();                              // picture loop - clear screen
    do {
       }  while(u8g.nextPage());
    irrecv.enableIRIn();                          // Start the IR receiver
    Serial.println("IR on");
}

void loop()
{
  if (irrecv.decode(&results))                    // If IR code is received, get the IR code.
    {
      Serial.print("IR code detected: ");
      Serial.println(results.value, HEX);
      irrecv.resume();                            // Resume decoding (necessary!)
    }
    u8g.firstPage();                              // picture loop
    do {
          draw();
       }  while(u8g.nextPage());
}

void draw(void) 
  {
    u8g.setFont(u8g_font_unifont);
    u8g.setPrintPos(0, 22);
    u8g.print(results.value, HEX);
  }
