// ----------------------------- Function that displays the main (first) screen --------------------------------------------------------------------
void main_disp(bool full_redraw)
  {
    int x;
    int y;
  
    if (full_redraw == true)
      {
        myGLCD.clrScr();
        //myGLCD.fillScr(0, 100, 0);
      }
    
    uint8_t i;
  
    // ------------------------------------- First row - Display Volume --------------------------------
    if (((volume != volumeOld) || (full_redraw == true)) && (Settings1.variable == true))
      {
        if (volume/2<10)
          {
            #ifdef BIG
              x = 130;  // x coordinate of where the volume display area begins
            #else
              x = 100;  // x coordinate of where the volume display area begins  
            #endif BIG
          }
        else 
          {
            #ifdef BIG
              x = 150;  // x coordinate of where the volume display area begins
            #else
              x = 120;  // x coordinate of where the volume display area begins  
            #endif BIG          
          }
           
        y = 0;   // y coordinate of where the volume display area begins
  
        #ifdef WHITE
          myGLCD.setColor(255, 255, 255);
          myGLCD.setBackColor(0, 0, 0);
        #else
          myGLCD.setColor(0, 0, 0);
          myGLCD.setBackColor(255, 255, 255);
        #endif WHITE
        myGLCD.setFont(calibri_bold_80);
        if (volume/2<10)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(x-5, y+25, x+30, y+45);
            myGLCD.setColor(255, 255, 255);
            myGLCD.print("- ", x+15, y);
          }
        else myGLCD.print("- ", x-15, y);
                
        if (volume/2<10)
          {
            #ifdef WHITE
              myGLCD.setColor(0, 0, 0);
              myGLCD.fillRect(x+45, y, x+125, y+70);
              myGLCD.setColor(255, 255, 255);
              myGLCD.setBackColor(0, 0, 0);
            #else
              myGLCD.setColor(255, 255, 255);
              myGLCD.fillRect(x+45, y, x+125, y+70);
              myGLCD.setColor(0, 0, 0);
              myGLCD.setBackColor(255, 255, 255);
            #endif WHITE
            myGLCD.setFont(Shruti_Bold_num_48x70);
            myGLCD.printNumI(volume/2, x+59, y);
          }
        else
          {
            myGLCD.setFont(Shruti_Bold_num_48x70);
            myGLCD.printNumI(volume/2, x+11, y);
          }
        myGLCD.setFont(calibri_bold_60);
  
        if (full_redraw == true)
          {
            if (volume/2<10)
              {
                myGLCD.setColor(0, 0, 0);
                myGLCD.fillRect(x+120, y+15, x+210, y+70);
              }
            else
              {
                myGLCD.setColor(0, 0, 0);
                myGLCD.fillRect(x+107, y+15, x+180, y+70);          
              }
            myGLCD.setColor(255, 255, 255);
            #ifdef BIG
              myGLCD.print("dB", 260, y+20);
            #else
              myGLCD.print("dB", 230, y+20); 
            #endif BIG            
          }
  
        volumeOld = volume;
      }
  
    // ------------------------------------- Second row, Left - Display Input --------------------------------
    if ((input != inputOld) || (select_inp_blue == true) || (do_select_inp==true) || (full_redraw == true))
      {
        myGLCD.setFont(calibri_bold_40);

        #ifdef BIG
          int x_bmp_input = 70;                 // X-Coordinate of the bitmap's top left corner
          int y_bmp_input = 85;                 // Y-Coordinate of the bitmap's top left corner
        #else
          int x_bmp_input = 50;                 // X-Coordinate of the bitmap's top left corner
          int y_bmp_input = 75;                 // Y-Coordinate of the bitmap's top left corner 
        #endif BIG
  
        int x_bmp_inp_size = 100;             // Width of the bitmap
        int y_bmp_inp_size = 100;             // Height of the bitmap
        
        #ifdef WHITE
          if (input == 2)
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, rca_b);
            }
          else if ((input == 0) || (input == 1))
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, usb_b);
            }
          else if ((input == 3) || (input == 4))
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, toslink_b);
            }
          else if (input == 5)
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, xlr_b);
            }          
          myGLCD.setColor(0, 0, 0);
          #ifdef BIG
            myGLCD.fillRect(10, 188, 215, 227);
          #else
            myGLCD.fillRect(0, 180, 200, 216);
          #endif BIG
          myGLCD.setColor(255, 255, 255);
        #else
          if (input == 2)
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, rca);
            }
          else if ((input == 0) || (input == 1))
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, usb);
            }
          else if ((input == 3) || (input == 4))
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, toslink);
            }
          else if (input == 5)
            {
              myGLCD.drawBitmap(x_bmp_input, y_bmp_input, x_bmp_inp_size, y_bmp_inp_size, xlr);
            }            
          myGLCD.setColor(255, 255, 255);
          #ifdef BIG
            myGLCD.fillRect(0, 186, 200, 220);
          #else
            myGLCD.fillRect(0, 180, 200, 216);
          #endif BIG
          myGLCD.setColor(0, 0, 0);
        #endif WHITE
  
        if ((do_select_inp == 1) || (select_inp_blue == 1))
          {
            if (do_select_inp == 1)
              {
                myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
                #ifdef BIG
                  myGLCD.print(myInputs[input], 120-(myGLCD.getStringWidth(myInputs[input])/2), 190);
                #else
                  myGLCD.print(myInputs[input], 90-(myGLCD.getStringWidth(myInputs[input])/2), 180);
                #endif BIG
                select_inp_blue = 1;
              }
            else if (select_inp_blue == 1)
              {
                myGLCD.setBackColor(0, 0, 0);             //set the background color of the text to black
                #ifdef BIG
                  myGLCD.print(myInputs[input], 120-(myGLCD.getStringWidth(myInputs[input])/2), 190);
                #else
                  myGLCD.print(myInputs[input], 90-(myGLCD.getStringWidth(myInputs[input])/2), 180);
                #endif BIG
                select_inp_blue = 0;
              }
          }
        
        #ifdef BIG
          myGLCD.print(myInputs[input], 120-(myGLCD.getStringWidth(myInputs[input])/2), 190);
        #else
          myGLCD.print(myInputs[input], 90-(myGLCD.getStringWidth(myInputs[input])/2), 180);
        #endif BIG
        inputOld = input;
      }
    
    // ------------------------------------- Second row, Right - Display signal type and SR --------------------------------
  
    if ((sig_type != sig_typeOld) || (lock != lockOld) || (full_redraw == true))
      {
        #ifdef BIG
          int x_bmp_sig = 310;                  // X-Coordinate of the bitmap's top left corner
          int y_bmp_sig = 85;                   // Y-Coordinate of the bitmap's top left corner 
        #else
          int x_bmp_sig = 250;                  // X-Coordinate of the bitmap's top left corner
          int y_bmp_sig = 75;                   // Y-Coordinate of the bitmap's top left corner 
        #endif BIG
  
        int x_bmp_sig_size = 100;             // Width of the bitmap
        int y_bmp_sig_size = 100;             // Height of the bitmap
        
        if (Settings1.variable == true)
          {
            yoffset = 160;                    // Location of Info when also displaying Volume bar
          }
        else yoffset = 133;                   // Location of Info when not displaying Volume bar
        
        #ifdef WHITE
          if (lock == 0)
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, nolock_b);
            } 
          else if ((sig_type == 0) || (sig_type == 3))
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, dsd_b);
            }
          else if (sig_type == 1)
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, spdif_b);
            }
          else if (sig_type == 2)
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, pcm_b);
            }
        #else
          myGLCD.setColor(0, 0, 0);
          if (lock == 0)
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, nolock);
            } 
          else if ((sig_type == 0) || (sig_type == 3))
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, dsd);
            }
          else if (sig_type == 1)
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, spdif);
            }
          else if (sig_type == 2)
            {
              myGLCD.drawBitmap(x_bmp_sig, y_bmp_sig, x_bmp_sig_size, y_bmp_sig_size, pcm);
            }
        #endif WHITE
              
        if ((SR != SR_Old) || (lock != lockOld) || (full_redraw == true))
          {
            char sig_to_disp[60] = "";
            String sig_temp;                      // String to display "Sampling Rate"
            sig_temp.reserve(15);
            
            myGLCD.setBackColor(0, 0, 0);             //set the background color of the text to black
            
            if (lock==0)
              {
                sig_temp = String("No Lock");
                lockOld = lock;
              }
            else if (lock==1)
              {
                if ((sig_type == 0) || (sig_type == 3))
                  {
                    String str2(mySR[SR]);
                    sig_temp = String(str2);
                  }
                else if ((sig_type == 1) || (sig_type == 2))
                  {
                    //String str(mySignal[sig_type]);
                    String str2(mySR[SR]);
                    sig_temp = String(str2);
                  }
                lockOld = lock;
              }
  
            sig_temp.toCharArray(sig_to_disp, 60);   
            myGLCD.setFont(calibri_bold_40);
            
            #ifdef WHITE
              myGLCD.setColor(0, 0, 0);
              #ifdef BIG
                myGLCD.fillRect(250, 190, 460, 220);
              #else
                myGLCD.fillRect(190, 183, 399, 212);
              #endif BIG
              myGLCD.setColor(255, 255, 255);
            #else
              myGLCD.setColor(255, 255, 255);
              #ifdef BIG
                myGLCD.fillRect(210, 186, 399, 212);
              #else
                myGLCD.fillRect(190, 183, 399, 212);
              #endif BIG
              myGLCD.setColor(0, 0, 0);
            #endif WHITE
            #ifdef BIG
              myGLCD.print(sig_to_disp, 360-(myGLCD.getStringWidth(sig_to_disp)/2), 190);
            #else
              myGLCD.print(sig_to_disp, 300-(myGLCD.getStringWidth(sig_to_disp)/2), 180);
            #endif BIG
            
            SR_Old = SR;
          }
      }

    // ------------------------------------- Third row - Display Filter --------------------------------    
     
    if ((filter != filterOld) || (full_redraw == true))
      {
        myGLCD.setFont(calibri_bold_26);

        #ifdef BIG
          #ifdef WHITE
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, 240, tft_x, tft_y);
            myGLCD.setColor(255, 255, 255);
          #else
            myGLCD.setColor(255, 255, 255);
            myGLCD.fillRect(0, 240, tft_x, tft_y);
            myGLCD.setColor(0, 0, 0);
          #endif WHITE
        #else
          #ifdef WHITE
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, 215, tft_x-1, tft_y-1);
            //myGLCD.fillRect(0, 215, 399, 239);
            myGLCD.setColor(255, 255, 255);
          #else
            myGLCD.setColor(255, 255, 255);
            myGLCD.fillRect(0, 215, tft_x-1, tft_y-1);
            myGLCD.setColor(0, 0, 0);
          #endif WHITE
        #endif BIG
        
        if (do_select_filter == 1)
          {
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
          }
        else myGLCD.setBackColor(0, 0, 0);             //set the background color of the text to black
        
        #ifdef BIG
          myGLCD.print(myFilters[filter], (tft_x/2)-(myGLCD.getStringWidth(myFilters[filter])/2), 240);
        #else
          myGLCD.print(myFilters[filter], (tft_x/2)-(myGLCD.getStringWidth(myFilters[filter])/2), 215);
        #endif BIG
        filterOld = filter;
      }
  }
