// ----------------------------- Function that displays the Settings menu --------------------------------------------------------------------
void settings_disp(bool full_redraw)
  {
    if (full_redraw == true)
      {
        myGLCD.clrScr();
      }
  
    char disp_buffer[60]="";
    String buffer_temp;
    buffer_temp.reserve(50);
    String temp_1;
    temp_1.reserve(30);
    String temp_2;
    temp_2.reserve(15);
    String temp;
    temp.reserve(5);
    int gap;
    
    #ifdef BIG
      gap = 15;
    #else
      gap = 0;
    #endif BIG
      
    yoffset = 0;
  
    if (full_redraw == true)
      {
        myGLCD.setFont(calibri_bold_40);
        myGLCD.setBackColor(0, 0, 0);
        myGLCD.print("Settings", (tft_x/2)-(myGLCD.getStringWidth("Settings")/2), yoffset);      
      }
    
    myGLCD.setFont(calibri_bold_26);
  
   
    // ------------------- Setting 1: Variable output setting -----------------------
    yoffset = 40+gap;
        
    if ((setting == 1) || (setting == 2) || (full_redraw == true))
      {
        temp_1 = String("DAC Output Volume: ");
        if (preamp == 0)
          {
            temp_2 = String("Fixed");
          }
        else if (preamp == 1)
          {
            temp_2 = String("Variable");
          }
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (setting == 1)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_1_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_1_select = true;
      }
    else if ((setting == 2) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_1_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_1_select = false;
      }
    else if ((setting == 2) && (setting_3_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_1_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_3_select = false;
      }
    setting_1_width = myGLCD.getStringWidth(disp_buffer);
  
    
    // ------------------- Setting 2: Default volume level setting -----------------------
    yoffset = 70+gap;
  
    if ((setting == 2) || (setting == 3) || (full_redraw == true))
      {      
        temp_1 = String("Default volume level: ");
        char volume_to_disp[60] = "";
        int volume_disp = preamp_def_vol / 2;
        temp = String(volume_disp);
        String temp_vol = String("-" + temp + "dB");
        buffer_temp = String(temp_1 + temp_vol);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
    if (setting == 2)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_2_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_2_select = true;
      }
    else if ((setting == 3) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_2_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);              //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_2_select = false;
      }
    else if ((setting == 3) && (setting_1_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_2_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_1_select = false;
      }
    setting_2_width = myGLCD.getStringWidth(disp_buffer);
  
    // ------------------- Setting 3: Backlight level setting -----------------------
    yoffset = 100+gap;
  
    if ((setting == 3) || (setting == 1) || (full_redraw == true))
      {
        temp_1 = String("Backlight level: ");
        char backlight_to_disp[10] = "";
        temp = String(backlight);
        buffer_temp = String(temp_1 + temp);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
      
    if (setting == 3)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_3_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_3_select = true;
      }
    else if ((setting == 1) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_3_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_3_select = false;
      }
    if ((setting == 1) && (setting_2_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, setting_3_width, yoffset+25);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        setting_2_select = false;
      }
    setting_3_width = myGLCD.getStringWidth(disp_buffer);
  }
