// ----------------------------- Function that displays the Settings menu --------------------------------------------------------------------
void menu_dpll_disp(bool full_redraw)
  {
    if (full_redraw == true)
      {
        myGLCD.clrScr();
      }
  
    char disp_buffer[60]="";
    String buffer_temp;
    buffer_temp.reserve(50);
    String temp_1;
    temp_1.reserve(30);
    String temp_2;
    temp_2.reserve(15);
    int gap0 = 30;
    int gap1;
    int gap2;
    int gap3;
    int char_height;
    
    #ifdef BIG
      gap1 = 30;              // Gap between rows
      gap2 = 10;              // Extra gap added only when using 4.3" TFT
      gap3 = 2;               // Extra gap added for settings on s/pdif inputs
      char_height = 24;
      myGLCD.setFont(calibri_bold_40);
    #else
      gap1 = 27;              // Gap between rows
      gap2 = 0;               // Extra gap added only when using 4.3" TFT
      gap3 = 3;               // Extra gap added for settings on s/pdif inputs
      if ((input == 0) || (input == 1))
        {
          char_height = 19;
        }
      else char_height = 24;
      myGLCD.setFont(calibri_bold_26);
    #endif BIG

    xoffset = 0;
    yoffset = 0;
  
    if (full_redraw == true)
      {
        myGLCD.setBackColor(0, 0, 0);
        temp_1 = String("DPLL Settings for ");
        temp_2 = String(myInputs[input]);
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
        myGLCD.setBackColor(0, 0, 0);
        myGLCD.print(disp_buffer, (tft_x/2)-(myGLCD.getStringWidth(disp_buffer)/2), yoffset);   
      }
    
    // ------------------- Setting 1: 768KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        
        xoffset = 0;
        yoffset = gap0 + gap2;
    
        if ((paramDPLL == 1) || (paramDPLL == 2) || (full_redraw == true))
          {
            temp_1 = String("768KHz: ");
            int DPLLPCM_tmp = Input[input].DPLLPCM1;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLPCM[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLPCM[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLPCM[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLPCM[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLPCM[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLPCM[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLPCM[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLPCM[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLPCM[8]);
              }  
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 1)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_1_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_1_select = true;
          }
        else if ((paramDPLL == 2) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_1_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_1_select = false;
          }
        else if ((paramDPLL == 2) && (paramDPLL_1_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_1_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_1_select = false;
          }
        paramDPLL_1_width = myGLCD.getStringWidth(disp_buffer);
      }

    // ------------------- Setting 2: 705.6KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        
        xoffset = 0;
        yoffset = gap0 + gap1 + gap2;
        
        if ((paramDPLL == 2) || (paramDPLL == 3) || (full_redraw == true))
          {
            temp_1 = String("705.6KHz: ");
            int DPLLPCM_tmp = Input[input].DPLLPCM2;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLPCM[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLPCM[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLPCM[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLPCM[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLPCM[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLPCM[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLPCM[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLPCM[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLPCM[8]);
              } 
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 2)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_2_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_2_select = true;
          }
        else if ((paramDPLL == 3) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_2_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_2_select = false;
          }
        else if ((paramDPLL == 3) && (paramDPLL_2_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_2_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_2_select = false;
          }
        paramDPLL_2_width = myGLCD.getStringWidth(disp_buffer);  
      }
      
    // ------------------- Setting 3: 384KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {    
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        
        xoffset = 0;
        yoffset = gap0 + 2*gap1 + gap2;
        
        if ((paramDPLL == 3) || (paramDPLL == 4) || (full_redraw == true))
          {
            temp_1 = String("384KHz: ");
            int DPLLPCM_tmp = Input[input].DPLLPCM3;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLPCM[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLPCM[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLPCM[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLPCM[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLPCM[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLPCM[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLPCM[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLPCM[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLPCM[8]);
              } 
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 3)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_3_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_3_select = true;
          }
        else if ((paramDPLL == 4) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_3_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_3_select = false;
          }
        else if ((paramDPLL == 4) && (paramDPLL_3_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_3_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_3_select = false;
          }
        paramDPLL_3_width = myGLCD.getStringWidth(disp_buffer);  
      }
      
    // ------------------- Setting 4: 352.8KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        
        xoffset = 0;
        yoffset = gap0 + 3*gap1 + gap2;
        
        if ((paramDPLL == 4) || (paramDPLL == 5) || (full_redraw == true))
          {
            temp_1 = String("352.8KHz: ");
            int DPLLPCM_tmp = Input[input].DPLLPCM4;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLPCM[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLPCM[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLPCM[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLPCM[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLPCM[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLPCM[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLPCM[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLPCM[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLPCM[8]);
              } 
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
        
        if (paramDPLL == 4)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_4_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_4_select = true;
          }
        else if ((paramDPLL == 5) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_4_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_4_select = false;
          }
        else if ((paramDPLL == 5) && (paramDPLL_4_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(0, yoffset, paramDPLL_4_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, 0, yoffset);
            paramDPLL_4_select = false;
          }
        paramDPLL_4_width = myGLCD.getStringWidth(disp_buffer); 
      }
    // ------------------- Setting 5: 192KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        xoffset = 0;
        yoffset = gap0 + 4*gap1 + gap2;
      }
    else
      {
        myGLCD.setFont(calibri_bold_26);
        xoffset = 0;
        yoffset = gap0 + gap2 + gap3;
      }
        
    if ((paramDPLL == 5) || (paramDPLL == 6) || (full_redraw == true))
      {
        temp_1 = String("192KHz: ");
        int DPLLPCM_tmp = Input[input].DPLLPCM5;
        if (DPLLPCM_tmp == 0)
          {
            temp_2 = String(myDPLLPCM[0]);
          }
        else if (DPLLPCM_tmp == 1)
          {
            temp_2 = String(myDPLLPCM[1]);
          }
        else if (DPLLPCM_tmp == 2)
          {
            temp_2 = String(myDPLLPCM[2]);
          }        
        else if (DPLLPCM_tmp == 3)
          {
            temp_2 = String(myDPLLPCM[3]);
          }        
        else if (DPLLPCM_tmp == 4)
          {
            temp_2 = String(myDPLLPCM[4]);
          }        
        else if (DPLLPCM_tmp == 5)
          {
            temp_2 = String(myDPLLPCM[5]);
          }  
        else if (DPLLPCM_tmp == 6)
          {
            temp_2 = String(myDPLLPCM[6]);
          }  
        else if (DPLLPCM_tmp == 7)
          {
            temp_2 = String(myDPLLPCM[7]);
          }  
        else if (DPLLPCM_tmp == 8)
          {
            temp_2 = String(myDPLLPCM[8]);
          } 
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (paramDPLL == 5)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_5_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_5_select = true;
      }
    else if ((paramDPLL == 6) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_5_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_5_select = false;
      }
    else if ((paramDPLL == 6) && (paramDPLL_5_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_5_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_5_select = false;
      }
    paramDPLL_5_width = myGLCD.getStringWidth(disp_buffer); 

    // ------------------- Setting 6: 176.4KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        xoffset = 0;
        yoffset = gap0 + 5*gap1 + gap2;
      }
    else
      {
        myGLCD.setFont(calibri_bold_26);
        xoffset = 0;
        yoffset = gap0 + gap1 + gap2 + 2*gap3;
      }
    
    if ((paramDPLL == 6) || (paramDPLL == 7) || (full_redraw == true))
      {
        temp_1 = String("176.4KHz: ");
        int DPLLPCM_tmp = Input[input].DPLLPCM6;
        if (DPLLPCM_tmp == 0)
          {
            temp_2 = String(myDPLLPCM[0]);
          }
        else if (DPLLPCM_tmp == 1)
          {
            temp_2 = String(myDPLLPCM[1]);
          }
        else if (DPLLPCM_tmp == 2)
          {
            temp_2 = String(myDPLLPCM[2]);
          }        
        else if (DPLLPCM_tmp == 3)
          {
            temp_2 = String(myDPLLPCM[3]);
          }        
        else if (DPLLPCM_tmp == 4)
          {
            temp_2 = String(myDPLLPCM[4]);
          }        
        else if (DPLLPCM_tmp == 5)
          {
            temp_2 = String(myDPLLPCM[5]);
          }  
        else if (DPLLPCM_tmp == 6)
          {
            temp_2 = String(myDPLLPCM[6]);
          }  
        else if (DPLLPCM_tmp == 7)
          {
            temp_2 = String(myDPLLPCM[7]);
          }  
        else if (DPLLPCM_tmp == 8)
          {
            temp_2 = String(myDPLLPCM[8]);
          } 
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (paramDPLL == 6)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_6_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_6_select = true;
      }
    else if ((paramDPLL == 7) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_6_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_6_select = false;
      }
    else if ((paramDPLL == 7) && (paramDPLL_6_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_6_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_6_select = false;
      }
    paramDPLL_6_width = myGLCD.getStringWidth(disp_buffer);

    // ------------------- Setting 7: 96KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        xoffset = 0;
        yoffset = gap0 + 6*gap1 + gap2;
      }
    else
      {
        myGLCD.setFont(calibri_bold_26);
        xoffset = 0;
        yoffset = gap0 + 2*gap1 + gap2 + 3*gap3;
      }
    
    if ((paramDPLL == 7) || (paramDPLL == 8) || (full_redraw == true))
      {
        temp_1 = String("96KHz: ");
        int DPLLPCM_tmp = Input[input].DPLLPCM7;
        if (DPLLPCM_tmp == 0)
          {
            temp_2 = String(myDPLLPCM[0]);
          }
        else if (DPLLPCM_tmp == 1)
          {
            temp_2 = String(myDPLLPCM[1]);
          }
        else if (DPLLPCM_tmp == 2)
          {
            temp_2 = String(myDPLLPCM[2]);
          }        
        else if (DPLLPCM_tmp == 3)
          {
            temp_2 = String(myDPLLPCM[3]);
          }        
        else if (DPLLPCM_tmp == 4)
          {
            temp_2 = String(myDPLLPCM[4]);
          }        
        else if (DPLLPCM_tmp == 5)
          {
            temp_2 = String(myDPLLPCM[5]);
          }  
        else if (DPLLPCM_tmp == 6)
          {
            temp_2 = String(myDPLLPCM[6]);
          }  
        else if (DPLLPCM_tmp == 7)
          {
            temp_2 = String(myDPLLPCM[7]);
          }  
        else if (DPLLPCM_tmp == 8)
          {
            temp_2 = String(myDPLLPCM[8]);
          } 
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (paramDPLL == 7)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_7_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_7_select = true;
      }
    else if ((paramDPLL == 8) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_7_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_7_select = false;
      }
    else if ((paramDPLL == 8) && (paramDPLL_7_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(0, yoffset, paramDPLL_7_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_7_select = false;
      }
    paramDPLL_7_width = myGLCD.getStringWidth(disp_buffer);

    // ------------------- Setting 9: 88.2KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
        #else
          myGLCD.setFont(calibri_bold_20);
        #endif BIG
        xoffset = 0;
        yoffset = gap0 + 7*gap1 + gap2;
      }
    else
      {
        myGLCD.setFont(calibri_bold_26);
        xoffset = 0;
        yoffset = gap0 + 3*gap1 + gap2 + 4*gap3;
      }
    
    if ((paramDPLL == 8) || (paramDPLL == 9) || (full_redraw == true))
      {
        temp_1 = String("88.2KHz: ");
        int DPLLPCM_tmp = Input[input].DPLLPCM8;
        if (DPLLPCM_tmp == 0)
          {
            temp_2 = String(myDPLLPCM[0]);
          }
        else if (DPLLPCM_tmp == 1)
          {
            temp_2 = String(myDPLLPCM[1]);
          }
        else if (DPLLPCM_tmp == 2)
          {
            temp_2 = String(myDPLLPCM[2]);
          }        
        else if (DPLLPCM_tmp == 3)
          {
            temp_2 = String(myDPLLPCM[3]);
          }        
        else if (DPLLPCM_tmp == 4)
          {
            temp_2 = String(myDPLLPCM[4]);
          }        
        else if (DPLLPCM_tmp == 5)
          {
            temp_2 = String(myDPLLPCM[5]);
          }  
        else if (DPLLPCM_tmp == 6)
          {
            temp_2 = String(myDPLLPCM[6]);
          }  
        else if (DPLLPCM_tmp == 7)
          {
            temp_2 = String(myDPLLPCM[7]);
          }  
        else if (DPLLPCM_tmp == 8)
          {
            temp_2 = String(myDPLLPCM[8]);
          } 
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (paramDPLL == 8)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, paramDPLL_8_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_8_select = true;
      }
    else if ((paramDPLL == 9) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, paramDPLL_8_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_8_select = false;
      }
    else if ((paramDPLL == 9) && (paramDPLL_8_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, paramDPLL_8_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, 0, yoffset);
        paramDPLL_8_select = false;
      }
    paramDPLL_8_width = myGLCD.getStringWidth(disp_buffer);

    // ------------------- Setting 10: 48KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
        #endif BIG
        yoffset = gap0 + gap2;
      }
    else
      {
        myGLCD.setFont(calibri_bold_26);
        xoffset = 0;
        yoffset = gap0 + 4*gap1 + gap2 + 5*gap3;
      }
    
    if ((paramDPLL == 9) || (paramDPLL == 10) || (full_redraw == true))
      {
        temp_1 = String("48KHz: ");
        int DPLLPCM_tmp = Input[input].DPLLPCM9;
        if (DPLLPCM_tmp == 0)
          {
            temp_2 = String(myDPLLPCM[0]);
          }
        else if (DPLLPCM_tmp == 1)
          {
            temp_2 = String(myDPLLPCM[1]);
          }
        else if (DPLLPCM_tmp == 2)
          {
            temp_2 = String(myDPLLPCM[2]);
          }        
        else if (DPLLPCM_tmp == 3)
          {
            temp_2 = String(myDPLLPCM[3]);
          }        
        else if (DPLLPCM_tmp == 4)
          {
            temp_2 = String(myDPLLPCM[4]);
          }        
        else if (DPLLPCM_tmp == 5)
          {
            temp_2 = String(myDPLLPCM[5]);
          }  
        else if (DPLLPCM_tmp == 6)
          {
            temp_2 = String(myDPLLPCM[6]);
          }  
        else if (DPLLPCM_tmp == 7)
          {
            temp_2 = String(myDPLLPCM[7]);
          }  
        else if (DPLLPCM_tmp == 8)
          {
            temp_2 = String(myDPLLPCM[8]);
          } 
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (paramDPLL == 9)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_9_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_9_select = true;
      }
    else if ((paramDPLL == 10) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_9_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_9_select = false;
      }
    else if ((paramDPLL == 10) && (paramDPLL_9_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_9_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_9_select = false;
      }
    paramDPLL_9_width = myGLCD.getStringWidth(disp_buffer);

    // ------------------- Setting 11: 44.1KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
        #endif BIG
        yoffset = gap0 + gap1 + gap2;
      }
    else
      {
        myGLCD.setFont(calibri_bold_26);
        xoffset = 0;
        yoffset = gap0 + 5*gap1 + gap2 + 6*gap3;
      }    
    
    if ((paramDPLL == 10) || (paramDPLL == 11) || (full_redraw == true))
      {
        temp_1 = String("44.1KHz: ");
        int DPLLPCM_tmp = Input[input].DPLLPCM10;
        if (DPLLPCM_tmp == 0)
          {
            temp_2 = String(myDPLLPCM[0]);
          }
        else if (DPLLPCM_tmp == 1)
          {
            temp_2 = String(myDPLLPCM[1]);
          }
        else if (DPLLPCM_tmp == 2)
          {
            temp_2 = String(myDPLLPCM[2]);
          }        
        else if (DPLLPCM_tmp == 3)
          {
            temp_2 = String(myDPLLPCM[3]);
          }        
        else if (DPLLPCM_tmp == 4)
          {
            temp_2 = String(myDPLLPCM[4]);
          }        
        else if (DPLLPCM_tmp == 5)
          {
            temp_2 = String(myDPLLPCM[5]);
          }  
        else if (DPLLPCM_tmp == 6)
          {
            temp_2 = String(myDPLLPCM[6]);
          }  
        else if (DPLLPCM_tmp == 7)
          {
            temp_2 = String(myDPLLPCM[7]);
          }  
        else if (DPLLPCM_tmp == 8)
          {
            temp_2 = String(myDPLLPCM[8]);
          } 
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (paramDPLL == 10)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_10_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_10_select = true;
      }
    else if ((paramDPLL == 11) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_10_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_10_select = false;
      }
    else if ((paramDPLL == 11) && (paramDPLL_10_select = true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_10_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_10_select = false;
      }
    paramDPLL_10_width = myGLCD.getStringWidth(disp_buffer);

    // ------------------- Setting 12: 32KHz DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
        #endif BIG
        yoffset = gap0 + 2*gap1 + gap2;      
      }
    else
      {
        myGLCD.setFont(calibri_bold_26);
        xoffset = 0;
        yoffset = gap0 + 6*gap1 + gap2 + 7*gap3;
      }   
    
    if ((paramDPLL == 11) || (paramDPLL == 12) || (paramDPLL == 5) || (full_redraw == true))
      {
        temp_1 = String("32KHz: ");
        int DPLLPCM_tmp = Input[input].DPLLPCM11;
        if (DPLLPCM_tmp == 0)
          {
            temp_2 = String(myDPLLPCM[0]);
          }
        else if (DPLLPCM_tmp == 1)
          {
            temp_2 = String(myDPLLPCM[1]);
          }
        else if (DPLLPCM_tmp == 2)
          {
            temp_2 = String(myDPLLPCM[2]);
          }        
        else if (DPLLPCM_tmp == 3)
          {
            temp_2 = String(myDPLLPCM[3]);
          }        
        else if (DPLLPCM_tmp == 4)
          {
            temp_2 = String(myDPLLPCM[4]);
          }        
        else if (DPLLPCM_tmp == 5)
          {
            temp_2 = String(myDPLLPCM[5]);
          }  
        else if (DPLLPCM_tmp == 6)
          {
            temp_2 = String(myDPLLPCM[6]);
          }  
        else if (DPLLPCM_tmp == 7)
          {
            temp_2 = String(myDPLLPCM[7]);
          }  
        else if (DPLLPCM_tmp == 8)
          {
            temp_2 = String(myDPLLPCM[8]);
          } 
        buffer_temp = String(temp_1 + temp_2);
        buffer_temp.toCharArray(disp_buffer, 120);
      }
  
    if (paramDPLL == 11)
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_11_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_11_select = true;
      }
    else if ((paramDPLL == 12) || (paramDPLL == 5) || (full_redraw == true))
      {
        myGLCD.setColor(0, 0, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_11_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_11_select = false;
      }
    else if ((paramDPLL == 12) && (paramDPLL_11_select = true))
      {
        myGLCD.setColor(0, 255, 0);
        myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_11_width, yoffset+char_height);
        myGLCD.setColor(255, 255, 255);
        myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
        myGLCD.print(disp_buffer, xoffset, yoffset);
        paramDPLL_11_select = false;
      }
    paramDPLL_11_width = myGLCD.getStringWidth(disp_buffer);

 // ------------------- Setting 14: DSD1024 DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
          yoffset = gap0 + 3*gap1 + gap2;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
          yoffset = gap0 + 3*gap1 + gap2;
        #endif BIG
        
        if ((paramDPLL == 12) || (paramDPLL == 13) || (full_redraw == true))
          {
            temp_1 = String("DSD1024: ");
            int DPLLPCM_tmp = Input[input].DPLLDSD1;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLDSD[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLDSD[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLDSD[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLDSD[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLDSD[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLDSD[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLDSD[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLDSD[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLDSD[8]);
              } 
            else if (DPLLPCM_tmp == 9)
              {
                temp_2 = String(myDPLLDSD[9]);
              } 
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 12)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_12_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_12_select = true;
          }
        else if ((paramDPLL == 13) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_12_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_12_select = false;
          }
        else if ((paramDPLL == 13) && (paramDPLL_12_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_12_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_12_select = false;
          }
        paramDPLL_12_width = myGLCD.getStringWidth(disp_buffer);
      }
      
// ------------------- Setting 15: DSD512 DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
          yoffset = gap0 + 4*gap1 + gap2;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
          yoffset = gap0 + 4*gap1 + gap2;
        #endif BIG
        
        if ((paramDPLL == 13) || (paramDPLL == 14) || (full_redraw == true))
          {
            temp_1 = String("DSD512: ");
            int DPLLPCM_tmp = Input[input].DPLLDSD2;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLDSD[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLDSD[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLDSD[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLDSD[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLDSD[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLDSD[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLDSD[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLDSD[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLDSD[8]);
              } 
            else if (DPLLPCM_tmp == 9)
              {
                temp_2 = String(myDPLLDSD[9]);
              }
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 13)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_13_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_13_select = true;
          }
        else if ((paramDPLL == 14) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_13_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_13_select = false;
          }
        else if ((paramDPLL == 14) && (paramDPLL_13_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_13_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_13_select = false;
          }
        paramDPLL_13_width = myGLCD.getStringWidth(disp_buffer);
      }
// ------------------- Setting 16: DSD256 DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
          yoffset = gap0 + 5*gap1 + gap2;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
          yoffset = gap0 + 5*gap1 + gap2;
        #endif BIG
        
        if ((paramDPLL == 14) || (paramDPLL == 15) || (full_redraw == true))
          {
            temp_1 = String("DSD256: ");
            int DPLLPCM_tmp = Input[input].DPLLDSD3;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLDSD[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLDSD[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLDSD[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLDSD[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLDSD[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLDSD[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLDSD[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLDSD[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLDSD[8]);
              } 
            else if (DPLLPCM_tmp == 9)
              {
                temp_2 = String(myDPLLDSD[9]);
              }
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 14)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_14_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_14_select = true;
          }
        else if ((paramDPLL == 15) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_14_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_14_select = false;
          }
        else if ((paramDPLL == 15) && (paramDPLL_14_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_14_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_14_select = false;
          }
        paramDPLL_14_width = myGLCD.getStringWidth(disp_buffer);
      }
// ------------------- Setting 17: DSD128 DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
          yoffset = gap0 + 6*gap1 + gap2;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
          yoffset = gap0 + 6*gap1 + gap2;
        #endif BIG
        
        if ((paramDPLL == 15) || (paramDPLL == 16) || (full_redraw == true))
          {
            temp_1 = String("DSD128: ");
            int DPLLPCM_tmp = Input[input].DPLLDSD4;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLDSD[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLDSD[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLDSD[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLDSD[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLDSD[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLDSD[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLDSD[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLDSD[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLDSD[8]);
              } 
            else if (DPLLPCM_tmp == 9)
              {
                temp_2 = String(myDPLLDSD[9]);
              }        
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 15)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_15_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_15_select = true;
          }
        else if ((paramDPLL == 16) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_15_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_15_select = false;
          }
        else if ((paramDPLL == 16) && (paramDPLL_15_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_15_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_15_select = false;
          }
        paramDPLL_15_width = myGLCD.getStringWidth(disp_buffer);
      }
// ------------------- Setting 18: DSD64 DPLL setting -----------------------
    if ((input == 0) || (input == 1))
      {
        #ifdef BIG
          myGLCD.setFont(calibri_bold_26);
          xoffset = 240;
          yoffset = gap0 + 7*gap1 + gap2;
        #else
          myGLCD.setFont(calibri_bold_20);
          xoffset = 200;
          yoffset = gap0 + 7*gap1 + gap2;
        #endif BIG
        
        if ((paramDPLL == 16) || (paramDPLL == 1) || (full_redraw == true))
          {
            temp_1 = String("DSD64: ");
            int DPLLPCM_tmp = Input[input].DPLLDSD5;
            if (DPLLPCM_tmp == 0)
              {
                temp_2 = String(myDPLLDSD[0]);
              }
            else if (DPLLPCM_tmp == 1)
              {
                temp_2 = String(myDPLLDSD[1]);
              }
            else if (DPLLPCM_tmp == 2)
              {
                temp_2 = String(myDPLLDSD[2]);
              }        
            else if (DPLLPCM_tmp == 3)
              {
                temp_2 = String(myDPLLDSD[3]);
              }        
            else if (DPLLPCM_tmp == 4)
              {
                temp_2 = String(myDPLLDSD[4]);
              }        
            else if (DPLLPCM_tmp == 5)
              {
                temp_2 = String(myDPLLDSD[5]);
              }  
            else if (DPLLPCM_tmp == 6)
              {
                temp_2 = String(myDPLLDSD[6]);
              }  
            else if (DPLLPCM_tmp == 7)
              {
                temp_2 = String(myDPLLDSD[7]);
              }  
            else if (DPLLPCM_tmp == 8)
              {
                temp_2 = String(myDPLLDSD[8]);
              } 
            else if (DPLLPCM_tmp == 9)
              {
                temp_2 = String(myDPLLDSD[9]);
              }        
            buffer_temp = String(temp_1 + temp_2);
            buffer_temp.toCharArray(disp_buffer, 120);
          }
      
        if (paramDPLL == 16)
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_16_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 255);             //set the background color of the text to blue
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_16_select = true;
          }
        else if ((paramDPLL == 1) || (full_redraw == true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_16_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_16_select = false;
          }
        else if ((paramDPLL == 1) && (paramDPLL_16_select = true))
          {
            myGLCD.setColor(0, 0, 0);
            myGLCD.fillRect(xoffset, yoffset, xoffset+paramDPLL_16_width, yoffset+char_height);
            myGLCD.setColor(255, 255, 255);
            myGLCD.setBackColor(0, 0, 0);               //set the background color of the text to black
            myGLCD.print(disp_buffer, xoffset, yoffset);
            paramDPLL_16_select = false;
          }
        paramDPLL_16_width = myGLCD.getStringWidth(disp_buffer);
      }    
  }
